﻿package
{
	import flash.display.*
	import flash.events.Event;
	import flash.geom.*
	
	import jp.maaash.ObjectDetection.ObjectDetector;
	import jp.maaash.ObjectDetection.ObjectDetectorEvent;
	import jp.maaash.ObjectDetection.ObjectDetectorOptions;
	
	import com.quasimondo.bitmapdata.CameraBitmap;
	[SWF(width="640", height="480", frameRate="30", backgroundColor="#FFFFFF")]
	
	import flash.display.MovieClip;
    import flash.display.Loader;
    import flash.events.*;
    import flash.net.URLRequest;
	
	public class Main extends Sprite
	{
		
		private var detector:ObjectDetector;
		
		private var g:Sprite;
		
		private var camera:CameraBitmap;
		private var detectionMap:BitmapData;
		private var drawMatrix:Matrix;
		private var scaleFactor:int = 4;
		private var w:int = 640;
		private var h:int = 480;
		
		private var lastTimer:int = 0;
		
		[Embed(source = "gafas.png")]
		private var gafaNose:Class;
		private var gafaBMP:Bitmap;
		
		

		public function Main() {
			iniciar();
			iniciarDetector();
			
			gafaBMP = Bitmap(new gafaNose());
			
			
			gafaBMP.scaleX = 0.5; // scaleFactor;
			gafaBMP.scaleY = 0.5 ;

		}

		private function iniciar():void{
			camera = new CameraBitmap(w, h);
			camera.addEventListener( Event.RENDER, cameraReadyHandler );
			addChild( new Bitmap( camera.bitmapData ) );
			g = Sprite(addChild(new Sprite()));
		}

		private function cameraReadyHandler( event:Event ):void
		{
			detectionMap = new BitmapData( w / scaleFactor, h / scaleFactor, false, 0 );
			detectionMap.draw(camera.bitmapData,new Matrix( 1/ scaleFactor, 0, 0, 1 / scaleFactor ),null,"normal",null,true);
			detector.detect( detectionMap );
		}

		private function iniciarDetector():void
		{
			detector = new ObjectDetector();
			
			var opcionesDetector:ObjectDetectorOptions = new ObjectDetectorOptions();
			opcionesDetector.min_size  = 30;
			detector.options = opcionesDetector;
			detector.addEventListener(ObjectDetectorEvent.DETECTION_COMPLETE, detectionHandler );
		}
		
		
		
		private function detectionHandler( e :ObjectDetectorEvent ):void
		{
			g.graphics.clear();
			if( e.rects ){
				g.graphics.lineStyle(2, 0xff0000);// black 2pix
				e.rects.forEach( function( r :Rectangle, idx :int, arr :Array ) :void {
					g.graphics.drawRect( r.x * scaleFactor, r.y * scaleFactor, r.width * scaleFactor, r.height * scaleFactor );
					addChild(gafaBMP);
					gafaBMP.x = (r.x * scaleFactor) + r.width * scaleFactor * 0.5;
					gafaBMP.x -= (gafaBMP.width * 0.5);
					gafaBMP.y = (r.y * scaleFactor) + r.height * scaleFactor * 0.20;
				
				});
			}
			
		}

		

	
	}
}
